 import React from 'react'
 import Head from "next/head"
import Layout from '@/components/Layout'
import AnimatedText from '@/components/AnimatedText'
import Link from 'next/link'
import Image from 'next/image'
import { GithubIcon } from '@/components/Icons'
import project1 from '../../public/images/projects/vf.jpg'

import project2 from '../../public/images/projects/dm.jpg'
import project5 from '../../public/images/projects/ajb.jpg'
import project4 from '../../public/images/projects/moolu.jpg'
import project3 from '../../public/images/projects/dc.jpg'
import project6 from '../../public/images/projects/prompt.jpg'

import {motion} from 'framer-motion'
import TransitionEffect from '@/components/TransitionEffect'

const FramerImage = motion(Image);

const FeaturedProject = ({type, title, summary, img, link, github}) => {
       return(
        <article className='w-full flex items-center relative justify-between rounded-br-2xl
        rounded-3xl border border-solid border-dark bg-light shadow-2xl p-12
         dark:bg-dark dark:border-light lg:flex-col lg:p-8 xs:rounded-2xl
          xs:rounded-br-3xl xs:p-4'>

      <div className='absolute top-0 -right-3 -z-10 w-[101%] h-[103%] rounded-[2.5rem]
       bg-dark rounded-br-3xl dark:bg-light sm:h-[102%] xs:w-full xs:rounded-[1.5rem]' 
      />
         
         <Link href={link} target='_blank'
         className='w-1-2 cursor-pointer overflow-hidden rounded-lg lg:w-full'>
            <FramerImage src={img} alt={title} className='w-full h-auto' 
             whileHover={{scale:1.05}}
             transition={{duration:0.2}}

             priority
             sizes="(max-width:768px) 100w,
             (max-width:1200px) 50vw,
             50vw"
             
            />
          </Link>

          <div className='w-1-2 flex flex-col items-start justify-between pl-6 lg:w-full lg:pl-0 lg:pt-6'>
            <span className='text-primary font-medium text-xl dark:text-primaryDark xs:text-base'>{type}</span>
            <Link href={link} target='_blank' className='hover:underline underline-offset-2'>
                <h2 className='my-2 w-full text-left text-4xl font-bold dark:text-light sm:text-sm'>{title}</h2>
            </Link>
            <p className='my-2  text-medium text-dark dark:text-light  sm:text-sm'>{summary}</p>
            <div className='mt-2 flex items-center'>
            <Link href={github} target="_blank" className='w-10'><GithubIcon />{""} </Link>
            <Link href={link} target="_blank"
              className='ml-4 rounded bg-dark text-light p-2 px-6 text-lg font-semibold
              dark:bg-light dark:text-dark
               sm:px-4 sm:text-base
              '
            >  Visit Project</Link>
            </div>
          </div>
          
      
        </article>
       )
}

const Project = ({title, type, img, link, github}) => {
     return(
      <article className='w-full flex flex-col items-center justify-center rounded-2xl border
       border-solid border-dark bg-light p-6 relative dark:bg-dark dark:border-light xs:p-4'>
         <div className='absolute top-0 -right-3 -z-10 w-[101%] h-[103%] rounded-[2rem]
          bg-dark rounded-br-3xl dark:bg-light md:-right-2 md:w-[101%] xs:h-[102%] xs:rounded-[1.5rem] '
      />

         <Link href={link}
          target='_blank'
         className='w-full cursor-pointer overflow-hidden rounded-lg'>
            <FramerImage src={img} alt={title} className='w-full h-auto' 
             whileHover={{scale:1.05}}
             transition={{duration:0.2}}
            />
          </Link>

          <div className='w-full flex flex-col items-start justify-between mt-4'>
            <span className='text-primary font-medium text-xl dark:text-primaryDark 
                             lg:text-lg md:text-base'>{type}</span>
            <Link href={link} target='_blank' className='hover:underline underline-offset-2'>
                <h2 className='my-2 w-full text-left text-3xl font-bold lg:text-2xl'>{title}</h2>
            </Link>
           
            <div className='w-full mt-2 flex items-center justify-between'>
            <Link
             href={link} 
            target="_blank"
            className=' text-lg font-semibold underline md:text-base'
            >  Visit
             </Link>
            <Link href={github} target="_blank" className='w-8 md:w-6'>
              <GithubIcon /> 
              </Link>
            
            </div>
          </div>
      </article>

     )
}





 
 const projects = () => {
   return (
     <>
   <Head>
       <title>Ogbonna_Michael | Projects  Page</title>
       <meta name="description" content='This page describes what I do as a software engineer'/>
    </Head>

    <TransitionEffect />

    <main className='w-full mb-16 flex flex-col items-center justify-center dark:text-light'>
        <Layout className='pt-16'> 
            <AnimatedText text="Imagination Trumps Knowledge" 
            className='mb-16    lg:!text-7xl sm:mb-8 sm!text-6xl xs:!text-4xl'
            />

            <div className='grid grid-cols-12 gap-24 gap-y-32 xl:gap-x-16 lg:gap-x-8 md:gap-y-24 sm:gap-x-0'>
               <div className='col-span-12'>
                <FeaturedProject
                title="Value Finders"
                img = {project1}
                summary="Valuefinders, an all encompassing online freelancers marketplace is created
                 to help remote and nearby skilled persons be found by organizations and individuals 
                 in need of their services"
                link ="http://valuefinders.org/"
                github='/'
                type="UI Design & Frontend Development"

                />
               
              
               </div>

             <div className='col-span-6 sm:col-span-12'>
                 <Project 
                  title="Danest Motors"
                  img = {project2}
                  summary=""
                  link ="https://danestmotors.com/"
                  github='/'
                  type="UI Design &  Development"
                 
                 
                 />
             </div>

             <div className='col-span-6 sm:col-span-12'>
             <Project 
                  title="Docare Foundation"
                  img = {project3}
                  summary=""
                  link ="https://docarefoundation.org/"
                  github='/'
                  type="UI Design &  Development"
                 
                 
                 />
             </div>


             <div className='col-span-12'> 
                <FeaturedProject
                title="Moolu Venture Lab"
                img = {project4}
                summary="The Moolu Venture Movement is a dynamic ecosystem that brings together a diverse community of entrepreneurs,
                 mentors, investors, and experts who are passionate about creating positive change. "
                link ="https://moolu.org/"
                github='/'
                type="Featured Project"

                /></div>



                    <div className='col-span-6 sm:col-span-12'>
                           <Project 
                  title="Ajebo Market Place"
                  img = {project5}
                  summary=""
                  link ="https://ajebo.com.ng/"
                  github='/'
                  type="UI Design & Developer"
                 
                 
                 />
                    </div>

                    <div className='col-span-6 sm:col-span-12'>
                           <Project 
                  title="Prompt Home Health"
                  img = {project6}
                  summary=""
                  link ="https://prompthomehealth.org/"
                  github='/'
                  type="UI Design & Development"
                 
                 
                 />
                    </div>


            </div>

        </Layout>
    </main>

     </>
   )
 }
 
 export default projects